using System.Collections.Generic;
using System.Linq;
#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7OruMessage_ObxSegment : BaseTest
	{
		#region Variables & Setup

        private static string _hl7Message;
 
	    [SetUp]
	    public void SetUp()
	    {
            _hl7Message = string.Concat(
                "MSH|^~\\&|IM|589|VBECS|589|20080526135401-0500||ORU^R01|1048|P|2.4|6||AL|NE",
                CARRIAGE_RETURN,
                "OBR|1|2953060005^OR||TAS|||||||||||||||ProVueSanDiego",
                CARRIAGE_RETURN,
                "OBX|1||AntiA||4+||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|2||SC2||0||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|3||ABSInterp||Neg||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|4||Comment||Testing Comment||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|5||AntiB||3+||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|6||A1Cells||0||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|7||BCells||0||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|8||AntiD||4+||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|9||DControl||0||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|10||ABOInterp||AB||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|11||RhInterp||Pos||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN,
                "OBX|12||SC1||0||||||F|||20151102085842||DNS   dobrak",
                CARRIAGE_RETURN);
	    }

	    #endregion


		#region Properties


		#endregion

        [Test]
        public void ObxFieldsTest_Pass()
	    {
	        List<string> errorList = new List<string>();

            string obxString = "OBX|1||AntiA||4+||||||F|||20151102085842||DNS   dobrak";

            HL7AIOruMessage.ObxSegment obxSegment = new HL7AIOruMessage.ObxSegment(obxString, '|', '^', ref errorList);
           
            Assert.AreEqual(0, errorList.Count , "errorList.Count");
            Assert.AreEqual(17, obxSegment.ObxFields.Count(), "ObxFields.Count");

	    }

	[NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
        public void get_SequenceNumberTest()
    {
        // TODO: Implement unit test for get_SequenceNumberTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
        public void get_TestNameTest()
    {
        // TODO: Implement unit test for get_TestNameTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_TestTypeIdTest()
    {
        // TODO: Implement unit test for get_TestTypeIdTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void set_TestTypeIdTest()
    {
        // TODO: Implement unit test for set_TestTypeIdTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_SpecimenActionCodeTest()
    {
        // TODO: Implement unit test for get_SpecimenActionCodeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_TestDateTimeTest()
    {
        // TODO: Implement unit test for get_TestDateTimeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    void get_TestResultIdTest()
    {
        // TODO: Implement unit test for get_TestResultIdTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_TestTechIdTest()
    {
        // TODO: Implement unit test for get_TestTechIdTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_OrderedTestGuidTest()
    {
        // TODO: Implement unit test for get_OrderedTestGuidTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void set_OrderedTestGuidTest()
    {
        // TODO: Implement unit test for set_OrderedTestGuidTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_PatientSpecimenGuidTest()
    {
        // TODO: Implement unit test for get_PatientSpecimenGuidTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void set_PatientSpecimenGuidTest()
    {
        // TODO: Implement unit test for set_PatientSpecimenGuidTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_OrderableTestIdTest()
    {
        // TODO: Implement unit test for get_OrderableTestIdTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void set_OrderableTestIdTest()
    {
        // TODO: Implement unit test for set_OrderableTestIdTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_OrderStatusCodeTest()
    {
        // TODO: Implement unit test for get_OrderStatusCodeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void set_OrderStatusCodeTest()
    {
        // TODO: Implement unit test for set_OrderStatusCodeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void get_RowVersionTest()
    {
        // TODO: Implement unit test for get_RowVersionTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void set_RowVersionTest()
    {
        // TODO: Implement unit test for set_RowVersionTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void ToStringTest()
    {
        // TODO: Implement unit test for ToStringTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void EqualsTest()
    {
        // TODO: Implement unit test for EqualsTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void GetHashCodeTest()
    {
        // TODO: Implement unit test for GetHashCodeTest
    }
    
    [NUnit.Framework.TestAttribute()]
    [NUnit.Framework.IgnoreAttribute()]
    public void GetTypeTest()
    {
        // TODO: Implement unit test for GetTypeTest
    }

	}
}
#endif